//
//  GSPieceInterpolation.h
//  GlyphsCore
//
//  Created by Georg Seifert on 25/10/2015.
//  Copyright (c) 2015 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>

#define AxisCount 40

@interface GSPieceMaster : NSObject {
  @public
	unsigned short count;
	bool axes[AxisCount];
	CGFloat factor;
	int _isOnAxis;
}

- (instancetype)initWithArray:(NSArray *)array;

@end

@interface GSPieceInstance : NSObject {
  @public
	unsigned short count;
	CGFloat axes[AxisCount];
}

- (instancetype)initWithArray:(NSArray *)array min:(CGFloat)minLimit max:(CGFloat)maxLimit;

@end

@interface GSPieceInterpolation : NSObject {
	NSArray *_masters;
	GSPieceInstance *_instance;
	CGFloat matrixes[AxisCount][AxisCount];
}
@property (nonatomic, strong) NSArray *masters;
@property (nonatomic, strong) GSPieceInstance *instance;
@end
